#include "pch.h"

#include "MPlayerKernel.h"

using namespace winrt::Windows::Foundation;
using namespace winrt::Windows::Media::Core;
using namespace winrt::Windows::Media::Playback;

struct MPlayerKernel::Impl {
  MediaPlayer mPlayer;

  Callback mOnOpenCallback;
  Callback mOnFinishCallback;
  Callback mOnFailedCallback;

  MediaPlaybackSession Session() {
    return mPlayer.PlaybackSession();
  }
};

MPlayerKernel::MPlayerKernel() {
  mImpl = std::make_unique<Impl>();

  mImpl->mPlayer.MediaOpened([this](MediaPlayer, IInspectable) {
    if (mImpl->mOnOpenCallback) {
      mImpl->mOnOpenCallback();
    }
  });
  mImpl->mPlayer.MediaEnded([this](MediaPlayer, IInspectable) {
    if (mImpl->mOnFinishCallback) {
      mImpl->mOnFinishCallback();
    }
  });
  mImpl->mPlayer.MediaFailed([this](MediaPlayer, IInspectable) {
    if (mImpl->mOnFailedCallback) {
      mImpl->mOnFailedCallback();
    }
  });
}

MPlayerKernel::~MPlayerKernel() {}

std::chrono::seconds MPlayerKernel::GetPosition() {
  return duration_cast<std::chrono::seconds>(mImpl->Session().Position());
}

std::chrono::seconds MPlayerKernel::GetTotalLength() {
  return duration_cast<std::chrono::seconds>(mImpl->Session().NaturalDuration());
}

void MPlayerKernel::SetMute(bool isMute) {
  mImpl->mPlayer.IsMuted(isMute);
}

void MPlayerKernel::SetVolume(int volume) {
  mImpl->mPlayer.Volume(volume / 100.0);
}

void MPlayerKernel::SetSource(const wchar_t *filePath) {
  std::wstring uri = std::format(L"file://{}", filePath);
  std::replace(uri.begin(), uri.end(), L'\\', L'/');

  mImpl->mPlayer.Source(MediaSource::CreateFromUri(Uri(uri)));
}

void MPlayerKernel::SetPosition(std::chrono::seconds pos) {
  if (mImpl->Session().PlaybackState() == MediaPlaybackState::Playing &&
      !mImpl->mPlayer.IsMuted()) {
    mImpl->mPlayer.IsMuted(TRUE);
    mImpl->mPlayer.Position(pos);

    Sleep(40);
    mImpl->mPlayer.IsMuted(FALSE);

  } else {
    mImpl->mPlayer.Position(pos);
  }
}

void MPlayerKernel::SetOnOpen(const Callback &callback) {
  mImpl->mOnOpenCallback = callback;
}

void MPlayerKernel::SetOnFinish(const Callback &callback) {
  mImpl->mOnFinishCallback = callback;
}

void MPlayerKernel::SetOnFailed(const Callback &callback) {
  mImpl->mOnFailedCallback = callback;
}

void MPlayerKernel::Play() {
  mImpl->mPlayer.Play();
}

void MPlayerKernel::Pause() {
  mImpl->mPlayer.Pause();
}

void MPlayerKernel::Stop() {
  mImpl->mPlayer.Pause();
  mImpl->Session().Position(TimeSpan{});
}
