#pragma once

class MPlayerKernel {
public:
  using Callback = std::function<void()>;

  MPlayerKernel();
  ~MPlayerKernel();

  std::chrono::seconds GetPosition();
  std::chrono::seconds GetTotalLength();

  void SetMute(bool isMute);
  void SetVolume(int volume);
  void SetSource(const wchar_t *filePath);
  void SetPosition(std::chrono::seconds pos);

  void SetOnOpen(const Callback &callback);
  void SetOnFinish(const Callback &callback);
  void SetOnFailed(const Callback &callback);

  void Play();
  void Pause();
  void Stop();

private:
  struct Impl;
  std::unique_ptr<Impl> mImpl;
};
